*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Naled                                                *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";
libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";

/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data Naled_avg;
     set epa.Naled_avg;
run;

proc sort data=Naled_avg;
     by id;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Naled - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Naled_avg);
ods rtf close;



*==> Human vs. rat;

title "Human vs. rat: final model 2b";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=Naled_avg  method=firo tech=newrap lis=3 maxiter=1000;
      PARMS ha=.5263		hb=.1859
			ra=0.6151		rb=.1097
			ga=0.3705	
			gab=.9789
			gb=.6659
			S2E=0.1532/best=1000;

            rha=ha+ua;
			rra=ra+ua;
            rhb=hb+ub;
			rrb=rb+ub;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-6 + H_I__M + rrb*Rat*1e-6 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  ua ub ~ normal([0, 0],  [ga*1e-1, gab*1e-2, gb*1e-2]) SUBJECT=ID Out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Naled human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=Naled, model=2)
ods rtf close;
%Calculate_Ki(chemical=Naled, Hadj=1e-6, Radj=1e-6);



*==> Adult vs. Infant;

title "final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=naled_avg(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=.55	adB=.22
			ia=.52 iB=.15
			gha=0.047	ghab=0.015 	ghb=0.008
			S2E=0.09774;
			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-6 + H_I__M*adult + rib*infant*1e-6 + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	   predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Naled Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=Naled, model=2);
ods rtf close;




*===> Male vs. female;

*===> model below was probably better (no WARNING), but was not selected by Exponent;
title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=naled_avg(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ma=.47 mb= 0.165
			fa=.59 fB=.21
			gha=.044 	ghab=.015 	ghb=.009
			S2E=.09908;

            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-6 + H_I__M*male + rfb*female*1e-6 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Naled Male-Female (correct model).rtf" startpage=no;
%DiagnosticsMF(chemical=Naled, model=2);
ods rtf close;

/*
title "model 3 - male vs. female Exponent model";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=naled_avg(where=(Human=1)) method=firo  tech=nrridg lis=3 maxiter=100000;
      PARMS ma=.47	mB=.18
			fa=.59 fB=.20
			gma=.019	gmab=0.005 	gmb=.012
			gfa=.064	gfab=.023 	gfb=.009
			S2E=.9863;
         	rma=ma+uma;
            rmb=mB+umb;
			rfa=fa+ufa;
			rfb=fB+ufb;
            PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-6 + H_I__M*male + rfb*female*1e-6 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-4);

      RANDOM  uma umb ufa ufb ~ normal([0, 0, 0, 0],   [gma, 
														gmab, gmb, 
														0,    0,     gfa, 
														0,    0,     gfab,   gfb]) SUBJECT=ID out=RandID_MF; 

	  ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Naled Male-Female (exponent model).rtf" startpage=no;
%DiagnosticsMF(chemical=Naled, model=3);
ods rtf close;
*/




*===> Caucasian vs. Others;

title "final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=naled_avg(where=(Human=1))  tech=newrap lis=3 method=firo maxiter=100000;
      PARMS ca=.56	cB=.20
			ora=.47 orB=.19
			gha=.043 	ghab=.016 	ghb=.001
			S2E=.009861;

            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-6 + H_I__M*caucasian + rorb*otherrace*1e-6 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb*10]) SUBJECT=ID out=RandID_CO; 
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  predict pred out=Resid_CO;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Naled Caucasian-Other Races.rtf" startpage=no;
%DiagnosticsCO(chemical=Naled, model=2);
ods rtf close;
